/* rygel-http-time-seek-response.c generated by valac 0.30.1, the Vala compiler
 * generated from rygel-http-time-seek-response.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 * Contact: http://www.cablelabs.com/
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelHTTPResponseElementPrivate RygelHTTPResponseElementPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE (rygel_http_time_seek_response_get_type ())
#define RYGEL_HTTP_TIME_SEEK_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse))
#define RYGEL_HTTP_TIME_SEEK_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponseClass))
#define RYGEL_IS_HTTP_TIME_SEEK_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE))
#define RYGEL_IS_HTTP_TIME_SEEK_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE))
#define RYGEL_HTTP_TIME_SEEK_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponseClass))

typedef struct _RygelHTTPTimeSeekResponse RygelHTTPTimeSeekResponse;
typedef struct _RygelHTTPTimeSeekResponseClass RygelHTTPTimeSeekResponseClass;
typedef struct _RygelHTTPTimeSeekResponsePrivate RygelHTTPTimeSeekResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST (rygel_http_time_seek_request_get_type ())
#define RYGEL_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))

typedef struct _RygelHTTPTimeSeekRequest RygelHTTPTimeSeekRequest;
typedef struct _RygelHTTPTimeSeekRequestClass RygelHTTPTimeSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;
typedef struct _RygelHTTPTimeSeekRequestPrivate RygelHTTPTimeSeekRequestPrivate;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelHTTPResponseElement {
	GObject parent_instance;
	RygelHTTPResponseElementPrivate * priv;
};

struct _RygelHTTPResponseElementClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
	gchar* (*to_string) (RygelHTTPResponseElement* self);
};

struct _RygelHTTPTimeSeekResponse {
	RygelHTTPResponseElement parent_instance;
	RygelHTTPTimeSeekResponsePrivate * priv;
};

struct _RygelHTTPTimeSeekResponseClass {
	RygelHTTPResponseElementClass parent_class;
};

struct _RygelHTTPTimeSeekResponsePrivate {
	gint64 _start_time;
	gint64 _end_time;
	gint64 _range_duration;
	gint64 _total_duration;
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _response_length;
	gint64 _total_size;
};

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPTimeSeekRequestPrivate * priv;
	gint64 start_time;
	gint64 end_time;
	gint64 range_duration;
	gint64 total_duration;
};

struct _RygelHTTPTimeSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_http_time_seek_response_parent_class = NULL;

GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_TIME_SEEK_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponsePrivate))
enum  {
	RYGEL_HTTP_TIME_SEEK_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE
};
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new (gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size);
RygelHTTPResponseElement* rygel_http_response_element_construct (GType object_type);
static void rygel_http_time_seek_response_set_start_time (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_end_time (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_total_duration (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_start_byte (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_end_byte (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_response_length (RygelHTTPTimeSeekResponse* self, gint64 value);
gint64 rygel_http_time_seek_response_get_response_length (RygelHTTPTimeSeekResponse* self);
#define RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED ((gint64) -1)
static void rygel_http_time_seek_response_set_total_size (RygelHTTPTimeSeekResponse* self, gint64 value);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_time_only (gint64 start_time, gint64 end_time, gint64 total_duration);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_time_only (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_with_length (gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 response_length);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_with_length (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 response_length);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_request_get_type (void) G_GNUC_CONST;
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_from_request (RygelHTTPTimeSeekRequest* time_seek_request, gint64 total_duration);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_from_request (GType object_type, RygelHTTPTimeSeekRequest* time_seek_request, gint64 total_duration);
static void rygel_http_time_seek_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request);
static gchar* rygel_http_time_seek_response_get_response_string (RygelHTTPTimeSeekResponse* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
#define RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER "TimeSeekRange.dlna.org"
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
gint64 rygel_http_time_seek_response_get_start_time (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_end_time (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_total_duration (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_start_byte (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_end_byte (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_total_size (RygelHTTPTimeSeekResponse* self);
static gchar* rygel_http_time_seek_response_real_to_string (RygelHTTPResponseElement* base);
gint64 rygel_http_time_seek_response_get_range_duration (RygelHTTPTimeSeekResponse* self);
static void rygel_http_time_seek_response_set_range_duration (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_finalize (GObject* obj);
static void _vala_rygel_http_time_seek_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_time_seek_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Construct a HTTPTimeSeekResponse with time and byte range
     *
     * start_time and start_byte must be specified.
     *
     * if total_duration and total_size are UNSPECIFIED, then the content
     * duration/size will be signaled as unknown ("*")
     *
     * if end_time is UNSPECIFIED, then the time range end will be omitted
     * from the response. If the end_byte is UNSPECIFIED, the entire byte
     * range response will be omitted. (see DLNA 7.5.4.3.2.24.3)
     */
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size) {
	RygelHTTPTimeSeekResponse * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp9_ = 0LL;
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = start_time;
	rygel_http_time_seek_response_set_start_time (self, _tmp0_);
	_tmp1_ = end_time;
	rygel_http_time_seek_response_set_end_time (self, _tmp1_);
	_tmp2_ = total_duration;
	rygel_http_time_seek_response_set_total_duration (self, _tmp2_);
	_tmp3_ = start_byte;
	rygel_http_time_seek_response_set_start_byte (self, _tmp3_);
	_tmp4_ = end_byte;
	rygel_http_time_seek_response_set_end_byte (self, _tmp4_);
	_tmp5_ = end_byte;
	rygel_http_time_seek_response_set_response_length (self, _tmp5_);
	_tmp6_ = self->priv->_response_length;
	if (_tmp6_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		_tmp7_ = self->priv->_response_length;
		_tmp8_ = start_byte;
		rygel_http_time_seek_response_set_response_length (self, _tmp7_ - (_tmp8_ - 1));
	}
	_tmp9_ = total_size;
	rygel_http_time_seek_response_set_total_size (self, _tmp9_);
	return self;
}


RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new (gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size) {
	return rygel_http_time_seek_response_construct (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration, start_byte, end_byte, total_size);
}


/**
     * Create a HTTPTimeSeekResponse only containing a time range
     *
     * Note: This form is only valid when byte-seek is not supported,
     * according to the associated resource's ProtocolInfo (see DLNA
     * 7.5.4.3.2.24.5)
     */
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_time_only (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration) {
	RygelHTTPTimeSeekResponse * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = start_time;
	rygel_http_time_seek_response_set_start_time (self, _tmp0_);
	_tmp1_ = end_time;
	rygel_http_time_seek_response_set_end_time (self, _tmp1_);
	_tmp2_ = total_duration;
	rygel_http_time_seek_response_set_total_duration (self, _tmp2_);
	rygel_http_time_seek_response_set_start_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	rygel_http_time_seek_response_set_end_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	rygel_http_time_seek_response_set_response_length (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	rygel_http_time_seek_response_set_total_size (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	return self;
}


RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_time_only (gint64 start_time, gint64 end_time, gint64 total_duration) {
	return rygel_http_time_seek_response_construct_time_only (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration);
}


/**
     * Construct a HTTPTimeSeekResponse with time and byte range and allowing
     * for a response length override. This is useful when the response body
     * is larger than the specified byte range from the original content
     * binary.
     *
     * start_time and start_byte must be specified.
     *
     * If total_duration and total_size are UNSPECIFIED, then the content
     * duration/size will be signaled as unknown ("*")
     *
     * if end_time is UNSPECIFIED, then the time range end will be omitted
     * from the response. If the end_byte is UNSPECIFIED, the entire byte
     * range response will be omitted. (see DLNA 7.5.4.3.2.24.3)
     */
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_with_length (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 response_length) {
	RygelHTTPTimeSeekResponse * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = start_time;
	rygel_http_time_seek_response_set_start_time (self, _tmp0_);
	_tmp1_ = end_time;
	rygel_http_time_seek_response_set_end_time (self, _tmp1_);
	_tmp2_ = total_duration;
	rygel_http_time_seek_response_set_total_duration (self, _tmp2_);
	_tmp3_ = start_byte;
	rygel_http_time_seek_response_set_start_byte (self, _tmp3_);
	_tmp4_ = end_byte;
	rygel_http_time_seek_response_set_end_byte (self, _tmp4_);
	_tmp5_ = response_length;
	rygel_http_time_seek_response_set_response_length (self, _tmp5_);
	_tmp6_ = total_size;
	rygel_http_time_seek_response_set_total_size (self, _tmp6_);
	return self;
}


RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_with_length (gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 response_length) {
	return rygel_http_time_seek_response_construct_with_length (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration, start_byte, end_byte, total_size, response_length);
}


/**
     * Create a HTTPTimeSeekResponse from a HTTPTimeSeekRequest
     *
     * Note: This form is only valid when byte-seek is not supported,
     * according to the associated resource's ProtocolInfo (see DLNA
     * 7.5.4.3.2.24.5)
     */
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_from_request (GType object_type, RygelHTTPTimeSeekRequest* time_seek_request, gint64 total_duration) {
	RygelHTTPTimeSeekResponse * self = NULL;
	RygelHTTPTimeSeekRequest* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	RygelHTTPTimeSeekRequest* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	g_return_val_if_fail (time_seek_request != NULL, NULL);
	_tmp0_ = time_seek_request;
	_tmp1_ = _tmp0_->start_time;
	_tmp2_ = time_seek_request;
	_tmp3_ = _tmp2_->end_time;
	_tmp4_ = total_duration;
	self = (RygelHTTPTimeSeekResponse*) rygel_http_time_seek_response_construct_time_only (object_type, _tmp1_, _tmp3_, _tmp4_);
	return self;
}


RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_from_request (RygelHTTPTimeSeekRequest* time_seek_request, gint64 total_duration) {
	return rygel_http_time_seek_response_construct_from_request (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, time_seek_request, total_duration);
}


static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self) {
	return g_boxed_copy (soup_message_headers_get_type (), self);
}


static gpointer __vala_SoupMessageHeaders_copy0 (gpointer self) {
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
}


static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self) {
	g_boxed_free (soup_message_headers_get_type (), self);
}


static void rygel_http_time_seek_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request) {
	RygelHTTPTimeSeekResponse * self;
	gchar* response = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	self = (RygelHTTPTimeSeekResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = rygel_http_time_seek_response_get_response_string (self);
	response = _tmp0_;
	_tmp1_ = response;
	if (_tmp1_ != NULL) {
		SoupMessageHeaders* headers = NULL;
		RygelHTTPRequest* _tmp2_ = NULL;
		SoupMessage* _tmp3_ = NULL;
		SoupMessageHeaders* _tmp4_ = NULL;
		SoupMessageHeaders* _tmp5_ = NULL;
		SoupMessageHeaders* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		RygelHTTPRequest* _tmp11_ = NULL;
		SoupMessage* _tmp12_ = NULL;
		SoupHTTPVersion _tmp13_ = 0;
		_tmp2_ = request;
		_tmp3_ = _tmp2_->msg;
		_tmp4_ = _tmp3_->response_headers;
		_tmp5_ = __vala_SoupMessageHeaders_copy0 (_tmp4_);
		headers = _tmp5_;
		_tmp6_ = headers;
		_tmp7_ = response;
		soup_message_headers_append (_tmp6_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp7_);
		_tmp8_ = self->priv->_response_length;
		if (_tmp8_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
			SoupMessageHeaders* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
			_tmp9_ = headers;
			_tmp10_ = self->priv->_response_length;
			soup_message_headers_set_content_length (_tmp9_, _tmp10_);
		}
		_tmp11_ = request;
		_tmp12_ = _tmp11_->msg;
		_tmp13_ = soup_message_get_http_version (_tmp12_);
		if (_tmp13_ == SOUP_HTTP_1_0) {
			SoupMessageHeaders* _tmp14_ = NULL;
			_tmp14_ = headers;
			soup_message_headers_replace (_tmp14_, "Pragma", "no-cache");
		}
		__vala_SoupMessageHeaders_free0 (headers);
	}
	_g_free0 (response);
}


static gchar* rygel_http_time_seek_response_get_response_string (RygelHTTPTimeSeekResponse* self) {
	gchar* result = NULL;
	gint64 _tmp0_ = 0LL;
	GString* response = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	GString* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gboolean _tmp13_ = FALSE;
	gint64 _tmp14_ = 0LL;
	GString* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_start_time;
	if (_tmp0_ == RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_string_new ("");
	response = _tmp1_;
	_tmp2_ = response;
	g_string_append (_tmp2_, "npt=");
	_tmp3_ = response;
	_tmp4_ = self->priv->_start_time;
	g_string_append_printf (_tmp3_, "%.3f-", ((gdouble) _tmp4_) / G_TIME_SPAN_SECOND);
	_tmp5_ = self->priv->_end_time;
	if (_tmp5_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		GString* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		_tmp6_ = response;
		_tmp7_ = self->priv->_end_time;
		g_string_append_printf (_tmp6_, "%.3f", ((gdouble) _tmp7_) / G_TIME_SPAN_SECOND);
	}
	_tmp8_ = self->priv->_total_duration;
	if (_tmp8_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		gdouble total = 0.0;
		gint64 _tmp9_ = 0LL;
		GString* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		_tmp9_ = self->priv->_total_duration;
		total = ((gdouble) _tmp9_) / G_TIME_SPAN_SECOND;
		_tmp10_ = response;
		_tmp11_ = total;
		g_string_append_printf (_tmp10_, "/%.3f", _tmp11_);
	} else {
		GString* _tmp12_ = NULL;
		_tmp12_ = response;
		g_string_append (_tmp12_, "/*");
	}
	_tmp14_ = self->priv->_start_byte;
	if (_tmp14_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		gint64 _tmp15_ = 0LL;
		_tmp15_ = self->priv->_end_byte;
		_tmp13_ = _tmp15_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GString* _tmp16_ = NULL;
		GString* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GString* _tmp21_ = NULL;
		GString* _tmp22_ = NULL;
		gint64 _tmp23_ = 0LL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		GString* _tmp26_ = NULL;
		gint64 _tmp27_ = 0LL;
		_tmp16_ = response;
		g_string_append (_tmp16_, " bytes=");
		_tmp17_ = response;
		_tmp18_ = self->priv->_start_byte;
		_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp18_);
		_tmp20_ = _tmp19_;
		g_string_append (_tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = response;
		g_string_append (_tmp21_, "-");
		_tmp22_ = response;
		_tmp23_ = self->priv->_end_byte;
		_tmp24_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp23_);
		_tmp25_ = _tmp24_;
		g_string_append (_tmp22_, _tmp25_);
		_g_free0 (_tmp25_);
		_tmp26_ = response;
		g_string_append (_tmp26_, "/");
		_tmp27_ = self->priv->_total_size;
		if (_tmp27_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
			GString* _tmp28_ = NULL;
			gint64 _tmp29_ = 0LL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			_tmp28_ = response;
			_tmp29_ = self->priv->_total_size;
			_tmp30_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp29_);
			_tmp31_ = _tmp30_;
			g_string_append (_tmp28_, _tmp31_);
			_g_free0 (_tmp31_);
		} else {
			GString* _tmp32_ = NULL;
			_tmp32_ = response;
			g_string_append (_tmp32_, "*");
		}
	}
	_tmp33_ = response;
	_tmp34_ = _tmp33_->str;
	_tmp35_ = g_strdup (_tmp34_);
	result = _tmp35_;
	_g_string_free0 (response);
	return result;
}


static gchar* rygel_http_time_seek_response_real_to_string (RygelHTTPResponseElement* base) {
	RygelHTTPTimeSeekResponse * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	self = (RygelHTTPTimeSeekResponse*) base;
	_tmp0_ = rygel_http_time_seek_response_get_response_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("HTTPTimeSeekResponse (%s)", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


gint64 rygel_http_time_seek_response_get_start_time (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start_time;
	result = _tmp0_;
	return result;
}


static void rygel_http_time_seek_response_set_start_time (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_time = _tmp0_;
	g_object_notify ((GObject *) self, "start-time");
}


gint64 rygel_http_time_seek_response_get_end_time (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end_time;
	result = _tmp0_;
	return result;
}


static void rygel_http_time_seek_response_set_end_time (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end_time = _tmp0_;
	g_object_notify ((GObject *) self, "end-time");
}


gint64 rygel_http_time_seek_response_get_range_duration (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_range_duration;
	result = _tmp0_;
	return result;
}


static void rygel_http_time_seek_response_set_range_duration (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_range_duration = _tmp0_;
	g_object_notify ((GObject *) self, "range-duration");
}


gint64 rygel_http_time_seek_response_get_total_duration (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_total_duration;
	result = _tmp0_;
	return result;
}


static void rygel_http_time_seek_response_set_total_duration (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_total_duration = _tmp0_;
	g_object_notify ((GObject *) self, "total-duration");
}


gint64 rygel_http_time_seek_response_get_start_byte (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start_byte;
	result = _tmp0_;
	return result;
}


static void rygel_http_time_seek_response_set_start_byte (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start_byte = _tmp0_;
	g_object_notify ((GObject *) self, "start-byte");
}


gint64 rygel_http_time_seek_response_get_end_byte (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end_byte;
	result = _tmp0_;
	return result;
}


static void rygel_http_time_seek_response_set_end_byte (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end_byte = _tmp0_;
	g_object_notify ((GObject *) self, "end-byte");
}


gint64 rygel_http_time_seek_response_get_response_length (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_response_length;
	result = _tmp0_;
	return result;
}


static void rygel_http_time_seek_response_set_response_length (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_response_length = _tmp0_;
	g_object_notify ((GObject *) self, "response-length");
}


gint64 rygel_http_time_seek_response_get_total_size (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_total_size;
	result = _tmp0_;
	return result;
}


static void rygel_http_time_seek_response_set_total_size (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_total_size = _tmp0_;
	g_object_notify ((GObject *) self, "total-size");
}


static void rygel_http_time_seek_response_class_init (RygelHTTPTimeSeekResponseClass * klass) {
	rygel_http_time_seek_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPTimeSeekResponsePrivate));
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = rygel_http_time_seek_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = rygel_http_time_seek_response_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_time_seek_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_time_seek_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_response_finalize;
	/**
	     * Effective range start time, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME, g_param_spec_int64 ("start-time", "start-time", "start-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Effective range end time, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME, g_param_spec_int64 ("end-time", "end-time", "end-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Effective range duration, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION, g_param_spec_int64 ("range-duration", "range-duration", "range-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The total duration of the resource, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION, g_param_spec_int64 ("total-duration", "total-duration", "total-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The start of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The end of the range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The response length in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH, g_param_spec_int64 ("response-length", "response-length", "response-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The length of the resource in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_http_time_seek_response_instance_init (RygelHTTPTimeSeekResponse * self) {
	self->priv = RYGEL_HTTP_TIME_SEEK_RESPONSE_GET_PRIVATE (self);
}


static void rygel_http_time_seek_response_finalize (GObject* obj) {
	RygelHTTPTimeSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
	G_OBJECT_CLASS (rygel_http_time_seek_response_parent_class)->finalize (obj);
}


GType rygel_http_time_seek_response_get_type (void) {
	static volatile gsize rygel_http_time_seek_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekResponse), 0, (GInstanceInitFunc) rygel_http_time_seek_response_instance_init, NULL };
		GType rygel_http_time_seek_response_type_id;
		rygel_http_time_seek_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelHTTPTimeSeekResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_response_type_id__volatile, rygel_http_time_seek_response_type_id);
	}
	return rygel_http_time_seek_response_type_id__volatile;
}


static void _vala_rygel_http_time_seek_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPTimeSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
	switch (property_id) {
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_start_time (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_end_time (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_range_duration (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_total_duration (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_start_byte (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_end_byte (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_response_length (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_time_seek_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPTimeSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
	switch (property_id) {
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME:
		rygel_http_time_seek_response_set_start_time (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME:
		rygel_http_time_seek_response_set_end_time (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION:
		rygel_http_time_seek_response_set_range_duration (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION:
		rygel_http_time_seek_response_set_total_duration (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE:
		rygel_http_time_seek_response_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE:
		rygel_http_time_seek_response_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH:
		rygel_http_time_seek_response_set_response_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE:
		rygel_http_time_seek_response_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



